       Integer Function IDTYPE( )
C
C       Looks for an ARK header line `DATATYPE' and returns an integer
C              -1 if zero-dimensional
C              0 if DATATYPE line does not exist or Unknown type is used
C              1 for Counts file, 2 for error of counts
C              3 for F-lambda file, 4 for error of F-lambda
C              5 for F-nu file, 6 for error of F-nu
C
       Integer K
       Character Code
C
       Character*80 a_Header( 180 )
       Common / pasDrs / a_Header
C
       Do K = 1, 36
         If( a_Header( K )( 1: 8 ) .eq. 'DATATYPE' ) Then
           Code = a_Header( K )( 30: 30 )
           If( Code .eq. 'Z' ) Then
             IDTYPE = -1
           Else If( Code .eq. 'C' ) Then
             IDTYPE = 1
           Else If( Code .eq. 'E' ) Then
             IDTYPE = 2
           Else If( Code .eq. 'L' ) Then
             IDTYPE = 3
           Else If( Code .eq. 'F' ) Then
             IDTYPE = 4
           Else If( Code .eq. 'N' ) Then
             IDTYPE = 5
           Else If( Code .eq. 'G' ) Then
             IDTYPE = 6
           Else
             IDTYPE = 0
           End If
           Return
         End If
       End Do
       IDTYPE = 0
C
       End
