program convert

  ! Takes the Seiss files and converts them into the standard format.

  implicit none

  real :: mass, age, teff, logg, logl
  real :: mbol, reff, rstar, rho
  integer :: model, phase, iostat
  character(len=120) :: input

  open(unit=1, file='siessz02.dat')
  open(unit=2, file='siessz02.iso')
  write(2,*) '-----------------------------------'
  write(2,*) 'm       age    Teff     g    log L'
  write(2,*) '-----------------------------------'


  do
    read(1,'(120a)',iostat=iostat) input
    print*, input
    if (iostat < 0) exit
    if (input(1:1) == '#') cycle
    read(input,*) model, phase, logl, mbol, reff, rstar, &
    teff, rho, logg, mass, age
    logl=log10(logl)
    age=age/1.0e+09
    write(2,*) mass, age, teff, logg, logl
  end do

end program convert
