module srt

contains

subroutine sort(xdata)

  implicit none

  real, dimension(:), intent(inout) :: xdata

  integer :: i, j, l, ir
  real :: xswap

  ir=size(xdata,1)

  if (ir < 1) then
    print*, ' Error in s/r sort.  Number of data points is ', ir
    stop
  else if (ir > 1) then
    ! If ir==1, then the data are already sorted!
    l=ir/2+1
    do
      if (l > 1)then
        l=l-1
        xswap=xdata(l)
      else
        xswap=xdata(ir)
        xdata(ir)=xdata(1)
        IR=IR-1
        if (ir == 1) then
          xdata(1)=xswap
          exit
        end if
      end if
      i=l
      j=l+l
20    IF(J.LE.IR)THEN
        IF(J.LT.IR)THEN
          IF(xdata(j) < xdata(j+1)) j=j+1
        ENDIF
        IF(xswap < xdata(j))THEN
          xdata(i)=xdata(j)
          I=J
          J=J+J
        ELSE
          J=IR+1
        ENDIF
        GO TO 20
      ENDIF
      xdata(i)=xswap
    end do
    
  end if
  
end subroutine sort

end module srt

program bootstrap

  use define_star
  use cmdfit_subs
  use ark_file_io
  use srt
  
  implicit none

  character(len=50) :: ifname
  integer :: nstar, ncol, istar, str_star
  character(len=10) , dimension(mcol) :: colstr
  type(a_star), dimension(:), allocatable :: star, strapped
  real :: harvest

  real, dimension(3) :: a_par, best_par
  ! The maximum number of available dimensions to search.
  integer, parameter :: maxdim=3
  real, dimension(2) :: start, end
  ! The names of those dimensions.
  character(len=16), parameter, dimension(maxdim) :: namdim=(/&
  'AGE             ', &
  'DISTANCE MODULUS', &
  'EXTINCTION      '/)
  ! The name of the label.
  character(len=7) :: axlab
  ! The value of the label.
  character(len=16) :: axnam
  ! A set of pointers which translate from the axis of the grid read in,
  ! to the internal grid, and a 3D counter
  integer, dimension(maxdim) :: kaxis, laxis
  ! Two more counters.
  integer :: iaxis
  ! An file name.
  character(len=50) :: ofname
  ! The maximum number of dimensions in the grid.
  integer, parameter :: griddim=2
  integer, dimension(griddim) :: ngrid_in, iax_in
  integer, dimension(maxdim) :: ngrid
  integer :: jax_in, iaxis1, iaxis2, iaxis3
  real, allocatable, dimension(:,:) :: grid, axgrid, axtau2
  real, allocatable, dimension(:,:,:) :: tau2
  ! The input grid.
  real, allocatable, dimension(:,:) :: axtau2_in, tau2_in
  real, allocatable, dimension(:) :: best_distrib
  integer :: iflag, istrap, icol2, icol, iunit, nstrap, i
  real :: best_value
  integer, dimension(3) :: ival
  integer :: nperif
  logical :: perif

  real, allocatable, dimension(:) :: strap

  integer, dimension(2) :: naxis
  real, dimension(:,:), allocatable :: data, axdata
  integer :: imag
  real :: work, test

  real :: delta_mag1, delta_mag2
  integer :: strap_type
  integer :: colflag, modflag, iminus, iband, correlated
  real :: tau_68
  integer, dimension(2) :: var_par
  integer :: nvar_par, nstar_good


  real, external :: rnd_gauss

  iflag=read_cluster_file(nstar, ncol, colstr, star) 

  print*, '* Will fit magnitude ', colstr(1)
  if (ncol == 2) then
    print*, '* Against colour ', colstr(2)
    icol2=2
  else
    print*, '* Available colours are '
    do icol=2, ncol
      print*, '* ', icol, colstr(icol) 
    end do
    print*, '> Give the number of the one you want.'
    read(*,*) icol2
  end if

  nstar_good=0
  good_star: do istar=1, nstar
    if (star(istar)%col(1)%flg /= 'OO') cycle good_star
    if (star(istar)%col(icol2)%flg /= 'OO') cycle good_star
    nstar_good=nstar_good+1
  end do good_star

  ! O.K., lets sort out the colours being fitted.
  colflag=-1
  do icol=1, n_names
    if (trim(col_name(icol)) == trim(colstr(icol2))) then
      if (trim(mag_name(icol)) == trim(colstr(1))) then
        print*, 'Fitting magnitude ', trim(mag_name(icol)), &
        ' against colour ', trim(col_name(icol))
        colflag=icol
      end if
    end if
  end do
  if (colflag == -1) then
    print*, 'Cannot find colours ', colstr(1), ' ', colstr(icol2)
    stop
  end if
  print*, 'Fitting colour flag ', colflag

  ! Now lets sort out whether you add or subtract the colour from the
  ! magnitude to get the other magnitude.
  iminus=index(colstr(icol2), '-')
  if (iminus == 0) then
    print*, 'Cannot find the minus sign in colour ', colstr(icol2)
    stop
  end if
  iband=index(colstr(icol2), trim(colstr(1)))
  if (iband == 0) then
    print*, 'Cannot find the magnitude ', trim(colstr(icol2)), &
    ' in the colour ', trim(colstr(icol2))
  else if (iband > iminus) then
    print*, 'Will add ', trim(colstr(1)), ' to ', trim(colstr(icol2)), &
    ' to create ', colstr(icol2)(1:iminus-1)
    correlated = 1
  else
    print*, 'Will subtract ', trim(colstr(1)), ' from ', trim(colstr(icol2)), &
    ' to create ', trim(colstr(icol2)(iminus+1:len(colstr(icol2))))
    correlated = -1
  end if

  print*, '> Which model number do you want?'
  read(*,*) modflag

  print*, '* Now to read in the tau-squared grid.'
  iflag=inpark(ngrid_in, tau2_in, axtau2_in)
  ! The first task is to find which axes of the input grid correspond
  ! to the axes of the grid we search.  The names and order of these
  ! axes are set up in the parameter statement for namdim.  The names
  ! should correspond to things written in the FITS header.
  kaxis=-1
  each_axis: do iaxis=1, maxdim
    do jax_in=1, griddim
      axlab='CTYPE?'
      write(axlab(6:6),'(i1.1)') jax_in
      iflag=get_header_s(axlab, axnam)
      if (iflag > 0) then
        if (trim(axnam) == trim(namdim(iaxis))) then
          kaxis(iaxis)=jax_in
          print*, 'Axis ', jax_in, ' of grid search was in ', trim(axnam)
          cycle each_axis
        end if
      end if
    end do
    ! If get to here, we have not found the matching axis so.
    if (iaxis == 3) then
      print*, '> Give the extinction in ', colstr(icol2)
    else
      print*, 'Give the value of ', trim(namdim(iaxis))
    end if
    read(*,*) a_par(iaxis)
  end do each_axis

  ! Now fill size of the search grid.
  do iaxis=1, maxdim
    if (kaxis(iaxis) > 0) then
      ngrid(iaxis)=ngrid_in(kaxis(iaxis))
    else
      ngrid(iaxis)=1
    end if
  end do
  
  ! First, which axes are we searching in?
  nvar_par=0
  do iaxis=1, maxdim
    if (ngrid(iaxis) > 1) then
      nvar_par=nvar_par+1
      if (nvar_par > 2) then
        print*, 'Cannot search in more than two parameters.'
        stop
      end if
      var_par(nvar_par)=iaxis
    end if
  end do

  ! Fill the axis array, and at the same time find the range of 
  ! parameters we will search.
  allocate(axtau2(maxval(ngrid_in),maxdim))
  do iaxis=1, maxdim
    if (ngrid(iaxis) > 1) then
      axtau2(:,iaxis)=axtau2_in(:,kaxis(iaxis))
    else
      axtau2(1,iaxis)=a_par(iaxis)
    end if
  end do

  do iaxis=1, nvar_par
    start(iaxis)=axtau2(1,                    var_par(iaxis))
      end(iaxis)=axtau2(ngrid(var_par(iaxis)),var_par(iaxis))
  end do

  ! Now fill the grid we will use for the search.
  iax_in=1
  allocate(tau2(ngrid(1),ngrid(2),ngrid(3)))
  do iaxis1=1, ngrid(1)
    if (kaxis(1) > 0) iax_in(kaxis(1))=iaxis1
    do iaxis2=1, ngrid(2)
      if (kaxis(2) > 0) iax_in(kaxis(2))=iaxis2
      do iaxis3=1, ngrid(3)
        if (kaxis(3) > 0) iax_in(kaxis(3))=iaxis3
        tau2(iaxis1, iaxis2, iaxis3)=tau2_in(iax_in(1), iax_in(2))
      end do
    end do
  end do

  if (nvar_par == 1) then
    allocate(grid(ngrid(var_par(1)), 1), axgrid(maxval(ngrid),2))    
  else
    allocate(grid(ngrid(var_par(1)), ngrid(var_par(2))), &
    axgrid(maxval(ngrid),2))
  end if
  allocate(best_distrib(nstar_good))

  open(unit=2, file='bootstrap.out') 
  write(2,*) 'Tau^2 from original grid, age, dm, tau^2 from new grid.'
  write(2,'(/)')

  print*, '> Which sort of bootstrap do you want?'
  print*, '*    1 = classical bootstrap.'
  print*, '*    2 = models based on scattering the datapoints.'
  print*, '*    3 = as above, but after returning colours to simulated values.'
  read(*,*) strap_type

  if (strap_type == 3) then
    print*, 'Then now read in the best fit model.'
    iflag=inpark(naxis, data, axdata)
    ! Normalise.
    do imag=1, naxis(2)
      work=sum(data(:,imag))
      if (work > 0.0) data(:,imag)=data(:,imag)/work
    end do
  end if

  print*, 'How many bootstraps do you want?'
  read(*,*) nstrap

  allocate(strap(nstrap))
  allocate(strapped(nstar_good))

  start=1
  end=1
  do iaxis=1, nvar_par
    print*, 'Searching range ', start(iaxis), end(iaxis), ' for ', &
         namdim(var_par(iaxis))
  end do

  nperif=0
  do istrap=1, nstrap
    call random_seed()
    str_star=0
    if (strap_type == 1) then
      print*, 'Doing bootstrap number ', istrap
      strap_star: do istar=1, nstar
        if (star(istar)%col(1)%flg /= 'OO') cycle strap_star
        if (star(istar)%col(icol2)%flg /= 'OO') cycle strap_star
        str_star=str_star+1
        call random_number(harvest)
        strapped(str_star)        = star(int(harvest*real(nstar))+1)
        strapped(str_star)%col(2) = star(int(harvest*real(nstar))+1)%col(icol2)
      end do strap_star
    else 
      !print*, 'Doing Monte Carlo number ', istrap
      monte_star: do istar=1, nstar
        if (star(istar)%col(1)%flg /= 'OO') cycle monte_star
        if (star(istar)%col(icol2)%flg /= 'OO') cycle monte_star
        str_star=str_star+1
        ! Now scatter the datapoint, assuming uncertainties are correlated.
        delta_mag1=rnd_gauss(0.0, star(istar)%col(1)%err)
        delta_mag2=rnd_gauss(0.0, sqrt(max(0.0, &
        star(istar)%col(icol2)%err**2.0 - star(istar)%col(1)%err**2.0)))
        strapped(str_star)=star(istar)
        strapped(str_star)%col(2)=star(istar)%col(icol2)
        if (strap_type == 3) then
          ! Move the star "back" to the right colour.
          call random_number(harvest)
          imag=minloc(abs(star(istar)%col(1)%data-axdata(1:naxis(2),2)),1)
          work=0.0
          back: do icol=1, naxis(1)
            work=work+data(icol,imag)
            if (work > harvest) then
              strapped(str_star)%col(2)%data=axdata(icol,1)
              exit back
            end if
          end do back
        end if
        ! Now add the uncertainties.
        strapped(str_star)%col(1)%data = & 
        strapped(str_star)%col(1   )%data + delta_mag1
        if (correlated == -1) then
          strapped(str_star)%col(2)%data = &
          strapped(str_star)%col(icol2)%data + delta_mag1 - delta_mag2
        else if (correlated == 1) then
          strapped(str_star)%col(2)%data = &
          strapped(str_star)%col(icol2)%data - delta_mag1 + delta_mag2
        end if
        !write(23,*) strapped(str_star)%col(2)%data, strapped(str_star)%col(1)%data, &
        !    strapped(str_star)%col(2)%err, strapped(str_star)%col(1)%err 
      end do monte_star
    end if
    ! If you need to get at each bootstrap dataset, this does it for you.
    !ofname='bootstrap.'
    !write(ofname(11:13), '(i3.3)') istrap
    !open (unit=26, file=ofname)
    !write(26,*) 2
    !write(26,'(/)')
    !do istar=1, str_star
    !  call write_star(26, strapped(istar), 2)
    !end do
    !close(26)

    !open (unit=26, file='bootstrap.002')
    !read(26,'(/,/)')
    !do istar=1, str_star
    !  iflag=read_star(26, strapped(istar), 2)
    !end do

    !write(20,*) a_par
    !write(20,*) colflag
    !write(20,*) modflag
    !write(20,*) correlated
    !write(20,*) start
    !write(20,*) end
    !write(20,*) -100.0
    call grid2d(a_par, strapped(1:str_star), colflag, modflag, correlated, &
         var_par, start, end, -100.0, &
         grid, axgrid, best_value, best_par, best_distrib)

    !print*, best_value, best_par

    ival=1
    perif=.false.
    do iaxis=1, 3
      if (ngrid(iaxis) > 1) then
        ival(iaxis)=minloc(abs(axtau2(1:ngrid(iaxis),iaxis)-best_par(iaxis)),1)
        if (ival(iaxis)==1 .or. ival(iaxis)==ngrid(iaxis)) then
          perif=.true.
          print*, i, axtau2(1,iaxis), best_par(iaxis), axtau2(ngrid(iaxis),iaxis)
        end if
      end if
    end do
    if (perif) nperif=nperif+1

    strap(istrap) = tau2(ival(1), ival(2), ival(3))


    print*, 'Bootstrap ', istrap, ' gave a tau^2 of ', strap(istrap)

    write(2,*) strap(istrap), best_par(1), best_par(2), best_value

  end do

  close(2)

  print*, ' '
  print*, 100.0-100.0*real(nperif)/real(nstrap), &
  'percent of points were inside the grid.'
  print*, 'You should not use confidence limits close to or above this level.'

  ! Now sort the strap array.
  call sort(strap)

  open(unit=2, file='bootstrap.sort') 
  write(2,*) 'Tau^2 from original grid, percentage confidence level.'
  write(2,'(/)')
  do istrap=1, nstrap
    write(2,*) strap(istrap), 100.0*real(istrap)/real(nstrap)
  end do
  close(2)

  print*, ' '
  tau_68=strap(nint(0.68*real(nstrap)))
  print*, '68 percent confidence level is at ', tau_68
  print*, &
  'Approximate 68 percent confidence limits for one parameter of interest are:'
  do iaxis=1, maxdim
    if (ngrid(iaxis) > 1) then
      from_bottom: do i=1, ngrid(iaxis)
        if (iaxis==1) then
          test=minval(tau2(i,:,:))
        else if (iaxis==2) then
          test=minval(tau2(:,i,:))
        else if (iaxis==3) then
          test=minval(tau2(:,:,i))
        end if
        if (tau_68 > test) then
          work=axtau2(i,iaxis)
          exit from_bottom
        end if
      end do from_bottom
      from_top: do i=ngrid(iaxis), 1, -1
        if (iaxis==1) then
          test=minval(tau2(i,:,:))
        else if (iaxis==2) then
          test=minval(tau2(:,i,:))
        else if (iaxis==3) then
          test=minval(tau2(:,:,i))
        end if
        if (tau_68 > test) then
          print*, trim(namdim(iaxis)), ' from ', work, ' to ', axtau2(i,iaxis)
          exit from_top
        end if
      end do from_top
    end if
  end do

end program bootstrap
