       Subroutine RDAI( X, Y, maxP, Pix, C, Order, iUnit, ifName, Flag )
C
C       This subroutine reads ARK and IUE files without asking the 
C       file type.  The Unit number passed to it is ignored.
C
        use get_header

       Integer maxP, Pix, Order, iUnit, Flag, Pix2
       Real X( maxP ), Y( maxP )
       Double Precision C( 0: 9 )
       Character*50 ifName
C
       Integer I, J, K, Labour, Test, Unit
       Real RMS
       Logical There, Warned
       Character Answer, ArkTyp*7
C
       Character*80 Dross( 180 ), Input
       Logical Debug
       Common / pasDrs / Dross
       Common / bug / Debug
C
       Real RIPOLY
C
       Do K = 1, 180
         Dross( K ) = ' '
       End Do
C
       Warned = .False.
       If( Flag .lt. 1000 ) Then       ! Interactive Mode
         Flag = 0
         There = .False.
         Do While( .not. There )       ! Keep asking
           Call WRITEN( 'Input file name (or END or $ VMS_command) >' )
           Read( *, '(A50)', End = 300 ) ifName
           If( ifName .eq. 'end' .or. ifName .eq. 'END' ) Then
             Flag = -1                     ! Abort reading
             If( Debug ) Call RDAI_ERROR( Flag )
             Return
           Else If( ifName( 1: 1 ) .eq. '$' ) Then
             Call arkcom( ifName( 2: 50 ))
           End If
            Call ARKINQ( ifName, ' ', There, ArkTyp )
         End Do
       Else                            ! Batch mode
         Flag = 0
          Call ARKINQ( ifName, ' ', There, ArkTyp )
         If( .not. There ) Then       ! Abort reading
           Flag = -2
           If( Debug ) Call RDAI_ERROR( Flag )
           Return
         End If
       End If
C
       Call ARKINQ( ifName, ' ', There, ArkTyp )
C
       If( ArkTyp .eq. 'ARK' ) Then       ! ARK file
         Flag = 1
          call arkopn(Unit, ifName, ' ', 'old', 'readonly', 
     1         'unformatted', 'sequential', 0)
         Read( Unit ) Pix, ( Dross( K ), K = 1, 36 )
         If( Pix .gt. maxP ) Then
           Flag = -99
           If( Debug ) Call RDAI_ERROR( Flag )
           Return
         End If
         Test = GET_HEADER_C( 'SIMPLE  ', Answer )
         If( Test .lt. 0 ) Then
           If( Debug ) Then
             Write( *, 110 )
110             Format( ' WARNING:: this is an old ARK file' )
             Warned = .True.
           End If
         Else If( Answer .ne. 'A' ) Then
           Flag = -11
           If( Debug ) Call RDAI_ERROR( Flag )
           Return
         End If
c         Test = GET_HEADER_C( 'REALTYPE', Answer )
c         If( Test .eq. -1 ) Then
c           If( Debug .and. .not. Warned ) Then
c             Write( *, 110 )
c           End If
c         Else If( Answer .ne. 'V' ) Then
c           Flag = -12
c           If( Debug ) Call RDAI_ERROR( Flag )
c           Return
c         End If
         Test = GET_HEADER_I( 'NAXIS   ', Labour )
         If( Test .eq. -1 ) Then
           If( Debug .and. .not. Warned ) Then
             Write( *, 110 )
             Warned = .True.
           End If
         Else If( Labour .ne. 1 ) Then
           If( Labour .eq. 2 ) Then
             Test = GET_HEADER_I( 'NAXIS2  ', Labour )
             If( Test .eq. -1 ) Then
              Flag = -21
              If( Debug ) Call RDAI_ERROR( Flag )
              Return
             Else If( Labour .ne. 1 ) Then
              Flag = -22
              If( Debug ) Call RDAI_ERROR( Flag )
              Return
             End If
           Else
             Flag = -13
             If( Debug ) Call RDAI_ERROR( Flag )
             Return
           End If
         End If
         Test = GET_HEADER_I( 'NAXIS1  ', Labour )
         If( Test .eq. -1 ) Then
           If( Debug .and. .not. Warned ) Then
             Write( *, 110 )
             Warned = .True.
           End If
         Else If( Labour .ne. Pix ) Then
           Flag = -14
           If( Debug ) Call RDAI_ERROR( Flag )
           Return
         End If
         Read( Unit ) ( Y( J ), J = 1, Pix )
         Read( Unit ) C
         Close( Unit )
         Do K = 0, 9
           If( C( K ) .ne. 0.0 ) Order = K
         End Do
         Do J = 1, Pix
           X( J ) = RIPOLY( J, C, Order )
         End Do
C
       Else                            ! IUE File
         Flag = 2
          call arkopn(Unit, ifName, ' ', 'old', 'readonly',
     &    'formatted', ' ', 0)
         J = 1
         Do While( .True. )
220           Read( Unit, '(A80)', End = 230 ) Input
            Read( Input, *, End = 220, Err = 220 ) X( J ), Y( J )
           J = J + 1
           If( J .gt. maxP ) Then
             Flag = -98
             If( Debug ) Call RDAI_ERROR( Flag )
             Return
           End If
         End Do
230         Continue
         Close( Unit )
          Pix = J - 1
         Order = 0
170       Do J = 1, 36
           Dross( J ) = ' '
         End Do
       End If
       
       Return
C
300       Continue
       Flag = -1
C
       End
    

