! This is the final version of extin, which was used to prove that I could
! use the latest version of grid2d instead of grid_extin.


module extin_sub

  contains

    subroutine grid_extin(a_par, dat, colflag, modflag, correlated, start, &
      end, soft_clip, &
      data, axdata, best_value, best_par, best_distrib, rnpts)

      use define_star
      use colteff_subs
      use cmdfit_subs

      implicit none

      ! Performs a 2d grid search.

      ! The model parameters.
      real, dimension(:) :: a_par
      ! The data points.
      type(a_star), dimension(:), intent(in) :: dat
      ! The model and colours being used.
      integer :: colflag, modflag
      ! The correlation flag for s/r likelihood.
      integer, intent(in) :: correlated
      ! The ranges of parameters to be searched.
      real, dimension(2), intent(in) :: start, end
      real, intent(in) :: soft_clip
      ! The output grid.
      real, dimension(:,:), intent(out) :: data, axdata
      ! And an optional fraction of the stars on the grid.
      real, dimension(:,:), intent(out), optional :: rnpts

      real, intent(out) :: best_value
      logical :: first_value
      real, intent(out), dimension(:) :: best_par
      real, intent(out), dimension(:) :: best_distrib

      ! Locals.
      character, allocatable, dimension(:) :: distrib_flag
      real, allocatable, dimension(:) :: distrib
      integer :: i1, i2, i3
      real, dimension(size(data,1), size(data,2), size(dat,1)) :: distrib_full
      real :: dummy, work, low_tau
      integer, dimension(2) :: loc

      allocate(distrib_flag(size(dat,1)), distrib(size(dat,1)))

      ! Set up the values of best_par to be those of a_par.  We'll
      ! the correct the ones we fit.
      best_par=a_par

      first_value=.true.
      do i1=1, size(data,1)
        if (size(data,1) == 1) then
          a_par(3)=start(1)
        else
          a_par(3)=start(1)+(end(1)-start(1))*real(i1-1)/real(size(data,1)-1)
        end if
        axdata(i1,1)=a_par(3)
        do i2=1, size(data,2)
          if (size(data,2) == 1) then 
            a_par(2)=start(2)
          else
            a_par(2)=start(2)+(end(2)-start(2))*real(i2-1)/real(size(data,2)-1)
          end if
          axdata(i2,2)=a_par(2)
          if (present(rnpts)) then
            dummy=func2d(a_par, dat, colflag, modflag, correlated, &
                 distrib_full(i1,i2,:), distrib_flag, rnpts(i1, i2))
          else 
            dummy=func2d(a_par, dat, colflag, modflag, correlated, &
                 distrib_full(i1,i2,:), distrib_flag)
          end if
        end do
      end do

      ! Find the highest probability in the whole fit.
      low_tau=-2.0*log(maxval(distrib_full))
      print*, 'Lowest tau-squared for any point is ', low_tau
      work=exp(-0.5*(soft_clip+low_tau))
      ! Correct the tau-squared values, and take logs.
      distrib_full=-2.0*log(distrib_full+work)

      data=0.0
      do i1=1, size(data,1)
        do i2=1, size(data,2)
          do i3=1, size(dat,1)
            data(i1,i2)=data(i1,i2) + distrib_full(i1,i2,i3)
          end do
        end do
      end do

      ! Find the best fit.
      loc=minloc(data)
      best_distrib=distrib_full(loc(1),loc(2),:)
      best_par(3)=axdata(loc(1),1)
      best_par(2)=axdata(loc(2),2)
      best_value=sum(best_distrib)

      deallocate(distrib_flag, distrib)

    end subroutine grid_extin

  end module extin_sub

program grid

  use define_star
  use cmdfit_subs
  use ark_file_io
  use colteff_subs
  use extin_sub

  implicit none

  integer, parameter :: n_par=3
  type(a_star), dimension(:), allocatable :: star
  real, dimension(n_par) :: a_par, best_par
  integer :: iflag, n_term, colflag, icol, modflag
  integer :: iostat, i
  integer :: points
  integer, dimension(2) :: naxis, jaxis
  real, dimension(2) :: start, end
  real, dimension(:,:), allocatable :: data, axdata, rnpts
  real :: best_value
  type(a_star) :: test
  integer :: icol1, icol2
  integer :: ncol
  character(len=10), dimension(:), allocatable :: bands
  character(len=50) :: ofname, ifname
  real, dimension(:), allocatable :: best_distrib

  type(a_star), dimension(:), allocatable :: dat

  integer :: nleft
  real, allocatable, dimension(:) :: sorted_distrib
  real :: clipped_tau
  real :: soft_clip

  integer :: iminus, iband, correlated
  integer, dimension(2) :: var_par

  real :: mag_shift, colour_shift
  real :: sys_mag, sys_col
  real :: low_tau
  logical :: col_col=.true.

  print*, '> Give input catalogue name.'
  read(*,'(a)') ifname
  open(unit=1, file=ifname, action='read')
  read(1,*) ncol
  allocate(bands(ncol))
  read(1,*) bands
  read(1,*)

  ! O.K., lets sort out the colours being fitted.
  if (col_col) then
    colflag=5
    icol1=3
  else
    colflag=4
    icol1=1
  end if
  icol2=2

  !icol1=2
  !icol2=3
  print*, 'Fitting ', trim(bands(icol2)), ' as X, and ', trim(bands(icol1)), &
  ' as Y.'
  correlated = 0
    
  print*, '> Give the extra uncertainty to be added to each magnitude.'
  read(*,*) sys_mag
  print*, '> Give the extra uncertainty to be added to each colour.'
  read(*,*) sys_col

  ! And the model.
  print*, 'The available models are '
  do i=1, n_models
    if (len_trim(mod_name(i)) > 0) print*, i, trim(mod_name(i))
  end do
  print*, '> Give the number for the model.'
  read(*,*) modflag

  points=0
  do
    iostat=read_star(1, test, ncol)
    if (iostat < 0) exit
    if (iostat > 0) then
      print*, 'Error reading file.'
      stop
    end if
    if (test%col(icol1)%flg /= 'OO') cycle
    if (test%col(icol2)%flg /= 'OO') cycle
    points=points+1
  end do
  allocate(star(points), best_distrib(points))

  rewind(1)
  read(1,'(/,/)')
  i=1
  do 
    iostat=read_star(1, test, ncol)
    if (iostat < 0) exit
    if (test%col(icol1)%flg /= 'OO') cycle
    if (test%col(icol2)%flg /= 'OO') cycle
    star(i)=test
    i=i+1
  end do
  print*, 'Read ', points, ' of ', trim(bands(icol1)), ' vs ', &
  trim(bands(icol2))

  ! Age.
  print*, '> Give age (in Myr).'
  read(*,*) a_par(1)
  if (.not. col_col) then
    ! The distance modulus.
    print*, '> Give the range in distance modulus to be searched.'
    read(*,*) start(2), end(2)
    print*, '> And the number of distance modulus points in the grid.'
    read(*,*) naxis(2)
  else
    start(2)=0.0
    end(2)=0.0
    naxis(2)=1
    var_par(2)=2
    a_par(2)=0.0
  end if
  ! The extinction in the colour in question.
  print*, '> Give range of reddening in ', trim(col_name(colflag))
  read(*,*) start(1), end(1)
  print*, '> And the number of reddening points in the grid.'
  read(*,*) naxis(1)
  var_par(1)=3

  ! The tau^2 at which data points get clipped out.
  print*, '> Give maximum allowed range of tau^2 (i.e. value of the soft clipping).'
  read(*,*) soft_clip

  allocate(data(naxis(1),naxis(2)), axdata(maxval(naxis),2), &
  rnpts(naxis(1),naxis(2)))

  n_term=2

  allocate(dat(points))

  do i=1, points
    ! Increase the uncertainties by the systematic.
    star(i)%col(icol1)%err  = sqrt(star(i)%col(icol1)%err**2.0 + sys_mag**2.0)
    ! Bug corrected here August 11 2006. 
    ! Used to be...
    ! star(i)%col(2)%err  = sqrt(star(i)%col(icol2)%err**2.0 + 2.0*(sys**2.0))
    ! The changed in the final stages of the NGC2169 paper (1st September 2006)
    ! to allow different uncertainties in mag and colour.
    star(i)%col(icol2)%err  = sqrt(star(i)%col(icol2)%err**2.0 + sys_col**2.0)
    ! Copy the star structure accross, which deals with colour 1.
    dat(i)=star(i)
    ! And now make sure colour 2 and 1 are right.
    dat(i)%col(1)%data = star(i)%col(icol1)%data
    dat(i)%col(1)%err  = star(i)%col(icol1)%err
    dat(i)%col(2)%data = star(i)%col(icol2)%data
    dat(i)%col(2)%err  = star(i)%col(icol2)%err
  end do

  !call grid_extin(a_par, dat, colflag, modflag, correlated, start, end, &
  !soft_clip, data, axdata, best_value, best_par, best_distrib, rnpts)

  call grid2d(a_par, dat, colflag, modflag, correlated, &
  var_par, start, end, &
  soft_clip, data, axdata, best_value, best_par, best_distrib, rnpts)

  low_tau=minval(best_distrib)

  ofname='grid.fit'
  call typark(2)
  call nxtark_out(ofname)
  jaxis=naxis
  if (naxis(2) == 1) then
    call put_header_s('CTYPE1', 'AGE', ' ', 1)
    open(unit=11, file=trim(ofname)//'.asc')
    write(11,'(/,/)')
    do i=1, naxis(1)
      write(11,*) axdata(i,1), data(i,1)
    end do
    close(11)
  else if (naxis(1) == 1) then
    call put_header_s('CTYPE1', 'DISTANCE MODULUS', ' ', 1)
    open(unit=11, file=trim(ofname)//'.asc')
    write(11,'(/,/)')
    do i=1, naxis(2)
      write(11,*) axdata(i,2), data(1,i)
    end do
    close(11)
    jaxis(1)=0
  else
    call put_header_s('CTYPE1', 'AGE', ' ', 1) 
    call put_header_s('CTYPE2', 'DISTANCE MODULUS', ' ', 1) 
  end if
  i=makark(jaxis, data, axdata)

  ofname='grid_npts.fit'
  call nxtark_out(ofname)
  i=makark(jaxis, rnpts, axdata)

  print*, 'Lowest value ', best_value
  do i=1, 2
    print*, ' '
    print*, ' For parameter ', i 
    print*, ' Range searched ', axdata(1,i), axdata(naxis(i),i)
    print*, ' Best value ', best_par
  end do

  call iso_image_name(modflag, colflag, best_par(1), ifname)
  call nxtark_in(ifname)
  iflag=inpark(naxis, data, axdata)


  ! Find the number of unclipped point.
  nleft=0
  clipped_tau=0.0
  do i=1, points
    ! If the value of tau is more than half that of a fully clipped point,
    ! clip it.
    ! write(66,*) dat(i)%col(2)%data, dat(i)%col(1)%data, best_distrib(i)
    if (best_distrib(i) < low_tau+soft_clip/2.0) then
      nleft=nleft+1
      clipped_tau=clipped_tau+best_distrib(i)
    end if
  end do

  print*, 'After removing clipped points, tau is ', clipped_tau
  print*, 'For ', nleft, ' data points.'

  ! Now allocate an array, and fill it with the values of tau.
  allocate(sorted_distrib(nleft))
  nleft=0
  do i=1, points
    if (best_distrib(i) < low_tau+soft_clip/2.0) then
      nleft=nleft+1
      sorted_distrib(nleft)=best_distrib(i)
    end if
  end do 

  ! Now sort them.
  call tau_sort(sorted_distrib)

  ! Write out the unclipped points in apparent magnitude.
  open(unit=32, file='unclipped.cat')
  write(32,*) ncol
  write(32,*) bands(1:ncol)
  write(32,*)
  do i=1, points
    if (best_distrib(i) < low_tau+soft_clip/2.0) &
    call write_star(32, star(i), ncol)
  end do
  close(32)

  ! Change to absolute magnitude and write out the unclipped points.
  do i=1, points
    star(i)%col(1)=star(i)%col(icol1)
    star(i)%col(2)=star(i)%col(icol2)
    call reddening(colflag, -best_par(2), -best_par(3), &
    star(i)%col(2)%data, star(i)%col(1)%data)
  end do

  bands(1)=trim(bands(icol1))//'o'
  iminus=index(bands(icol2), '-')
  bands(2)=bands(icol2)(1:iminus-1)//'o'//&

  trim(bands(icol2)(iminus:len(bands(icol2))))//'o'
  open(unit=32, file='unclipped_abs.cat')
  write(32,*) 2
  write(32,*) bands(1:2)
  write(32,*)
  do i=1, points
    if (best_distrib(i) < low_tau+soft_clip/2.0) &
    call write_star(32, star(i), 2)
  end do
  close(32)

  ! Apply the shifts to the image to make it in apparent space.
  mag_shift=0.0
  colour_shift=0.0
  call reddening(colflag, -best_par(2), -best_par(3), &
  colour_shift, mag_shift)
  axdata(1:naxis(1),1)=axdata(1:naxis(1),1)-colour_shift
  axdata(1:naxis(2),2)=axdata(1:naxis(2),2)-mag_shift

  call nxtark_out('best_model.fit')
  iflag=makark(naxis, data, axdata)

  open(unit=22, file='distrib.tau')
  write(22, '(/,/)')
  write(22,*) 0.0, 1.0
  do i=1, nleft
    write(22,*) sorted_distrib(i), real(nleft-i+1)/real(nleft)
    write(22,*) sorted_distrib(i), real(nleft-i)/real(nleft)
  end do
  close(22)

end program grid
