program iso

  use cmdfit_subs
  use colteff_subs
  use define_star

  implicit none

  integer :: i, colflag, modflag, istar
  integer :: iage, nage
  real :: age, age_low, age_high
  character(len=50) :: ofname
  character(len=8) :: age_name
  integer :: i1, i2
  real :: mass, low_mass, high_mass

  real :: p_mass, p_teff
  character(len=50) :: isoflag
  ! The number of stars in the simulation.
  integer, parameter :: nstar=10000

  type (a_star) :: star

  ! This used to be hard coded 0.04 3.0
  print*, 'What range of masses do you want (low, high)?'
  read(*,*) low_mass, high_mass

  print*, 'The following models are available.'
  do i=1, n_models
    if (len_trim(mod_name(i)) > 0) print*, i, trim(mod_name(i))
  end do
  print*, 'What model number do you want?'
  read(*,*) modflag

  print*, 'The available CMDs are '
  do i=1, n_names
    if (len_trim(mag_name(i)) > 0) & 
    print*, i, trim(mag_name(i)), ' vs ', trim(col_name(i)), &
    '   ('//trim(pht_comm(i))//')'
  end do
  print*, 'What colour number do you want?'
  read(*,*) colflag

  print*, 'What log10(age) do you want?'
  read(*,*) age


  ! Write out a simple isochrone file.
  call iso_image_name(modflag, colflag, age, ofname)
  open (unit=12, file=trim(ofname)//'.iso')
  write(12,*) 'Colour, magnitude, mass, teff, flag.'
  write(12,*)
  write(12,*)
  ! And a cluster format catalogue.
  open (unit=11, file=trim(ofname)//'.cat')
  write(11,*) ' 2 colours'
  write(11,*) mag_name(colflag), ' ', col_name(colflag)
  write(11,*)
  call zero_star(star)
  star%col(1:2)%err=0.01
  star%col(1:2)%flg='OO'

  each_single_star: do istar=1, nstar

    mass=low_mass + (high_mass-low_mass)*real(istar)/real(nstar)

    call make_star(age, colflag, modflag, mass, mass, -0.1, &
    1, star%col(1)%data, star%col(2)%data, p_mass, p_teff, isoflag)
    write(12,*) star%col(2)%data, star%col(1)%data, p_mass, p_teff, &
    trim(isoflag)
    call write_star(11, star, 2)

  end do each_single_star
  close(12)
  close(11)

end program iso
