program distance_spread

  ! Take a normal simulation and then make it look like group spread in
  ! distance by smearing it with a Gaussian in magnitude space.

  use ark_file_io
  use cmdfit_subs
  use define_star

  implicit none

  integer :: i1, i2
  real, dimension(:,:), allocatable, save :: data, axdata, output
  integer, dimension(2) :: naxis
  integer :: iflag
  character :: flag
  real :: norm
  ! The gradient.  By leaving this unallocated we don't use it.
  real, dimension(:), allocatable :: grad
  real :: spread

  print*, 'First read in the basic model FITS file.'
  iflag=inpark(naxis, data, axdata)
  if (iflag < 0) then
    print*, 'Error reading 2D isochrone file.'
    stop
  end if

  allocate(output(naxis(1), naxis(2)))

  print*, '> Give spread in magnitude.'
  read(*,*) spread

  output=0.0
  do i2=1, naxis(2)
    do i1=1, naxis(1)
      output(i1,i2)=likelihood(data, axdata, grad, i1, i2, &
      axdata(2,1)-axdata(1,1), spread, 0, flag)
    end do
  end do

  !  Now normalise to one.
  output=output/&
  abs(sum(data)*(axdata(2,1)-axdata(1,1))*(axdata(2,2)-axdata(1,2)))

  ! Make a file of the output data to look at it.
  iflag=makark(naxis, output, axdata)

end program distance_spread
