       Subroutine SAVAI(X, Y, min, Pix, C, Order, Unit, of_Name, Flag)
C
C      Unit is ignored unless it is supplied as opened.
C
       use get_header

       implicit none

C      IUE is a logical which controls if IUE or ASCII files are 
c      written.
       Logical IUE
       Parameter ( IUE = .True. )
C
       Integer min, Pix, Order, Unit, Flag
       Real X( Pix ), Y( Pix )
       Double Precision C( 0: 9 )
       Character*50 of_Name
C
       Real RMS
       Integer n_Dross, length, I, J, K, in_Flag, iUnit
       Logical There
       Character Answer
C
       Character*80 Dross( 180 )
       Logical add_Comments
       Common / pasDrs / Dross
       Common / addCom / add_Comments
C
       Real RIPOLY
C
C      Is the Flag OK?
       If ( Flag.ne.1 .and. Flag.ne.2 ) Then
         print*, 'ERROR:: SAVAI was called with illegal flag ', Flag
         Flag = -1
          Return
        End if
              
       If( Unit .eq. 0 ) Unit = 98
       Inquire( Unit, Opened = There )
       If( There ) Then              ! Batch mode...simple
         If( Flag .eq. 1 ) Then       ! ARK file
           Call SAVE_AI_ARK( X, Y, min, Pix, C, Order, Unit )
           Return
         Else If( Flag .eq. 2 ) Then       ! ASCII/IUE file
           If (IUE) Call WRITE_IUE_HEADER( Unit, min, Pix )
           Do J = min, Pix
             Write( Unit, * ) X( J ), Y( J )
           End Do
           Close( Unit )
           Return
         End If
       End If
C
c       User can change his/her mind about the format.
       in_Flag = Flag
c       The default is ARK.
       If( in_Flag .ne. 1 .and. in_Flag .ne. 2 ) in_Flag = 1
       Do While( .True. )
         If( in_Flag .eq. 1 ) Then
c         ARK (provisional).
            If (IUE) then
             Call WRITEN
     1       ('Output ARK file name (or IUE or END or $ DCL_command) >')
            Else
             Call WRITEN
     1 ('Output ARK file name (or ASCII or END or $ DCL_command) >')
            End If
           Read( *, '(A50)' ) of_Name
           If( of_Name .eq. 'END' .or. of_Name .eq. 'end' ) Then
c             Abort.
             Write( *, '('' WARNING:: No output file written'')' )
             Flag = -1
             Return
            Else If( of_Name( 1: 1 ) .eq. '$' ) Then
C             Operating system command.
             Call arkcom( of_Name( 2: 50 ))
           Else If( (of_Name .eq. 'iue' .or. of_Name .eq. 'IUE')
     1        .and. IUE) Then
             If( Flag .eq. 1 ) Then
              Write( *, '('' Changing to IUE format'')' )
             Else
              Write( *, '('' Returning to IUE format'')' )
             End If
             in_Flag = 2
               Else If( (of_Name .eq. 'ascii' .or. of_Name .eq. 'ASCII')
     1        .and. .not. IUE) Then
             If( Flag .eq. 1 ) Then
              Write( *, '('' Changing to ASCII format'')' )
             Else
              Write( *, '('' Returning to ASCII format'')' )
             End If
             in_Flag = 2
           Else
             n_Dross = LNDRSS( )
             If( add_Comments ) Then
C               Add comments if flag is set.
                If( n_Dross .ne. 0 ) Then
                If(Dross( n_Dross ) .eq. 'END') n_Dross = n_Dross - 1
                End If
              If( n_Dross .le. 34 ) Then
                 Write( *, 140 ) 35 - n_Dross
140              Format(' * Enter comment below, up to ', I2, ' lines',
     1                    ' (<68 letters/line) ...<CR> when finished.' )
                I = n_Dross + 1
                Do While( I .lt. 36 )
                  Read( *, '(A70)', End = 150 ) Dross( I )( 12: 79 )
                  If( Dross( I )( 12: 79 ) .eq. ' ' ) Goto 150
                  Dross( I )( 1: 11 ) = 'COMMENT = '''
                  Do K = 80, 12, -1
                    If( Dross( I )( K: K ) .ne. ' ' .and.
     1                    Dross( I )( K: K ) .ne. Char( 0 ) ) Goto 145
                  End Do
145                  Continue
                  K = K + 1
                  Dross( I )( K: K ) = ''''
                  I = I + 1
                End Do
150                Continue
                Dross( I ) = 'END'
              Else If( n_Dross .eq. 35 ) Then
                Dross( 36 ) = 'END'
              End If
             End If
              call arkopn(iUnit, of_Name, ' ', 'new', 'overwrite',
     &             'unformatted', 'sequential', 0)
             Call SAVE_AI_ARK( X, Y, min, Pix, C, Order, iUnit )
             If( add_Comments ) Then
C               Clear the comments added to DROSS during SAVAI.
              Dross( n_Dross + 1 ) = 'END'
              Do I = n_Dross + 2, 36
                Dross( I ) = ' '
              End Do
             End If
             Return
           End If
         Else If( in_Flag .eq. 2 ) Then
C           ASCII/IUE (provisional).
            If (IUE) Then
             Call WRITEN
     1       ('Output IUE file name (or ARK or END or $ DCL_command) >')
            Else
             Call WRITEN
     1  ('Output ASCII file name (or ARK or END or $ DCL_command) >')
            End if
           Read( *, '(A50)' ) of_Name
           If( of_Name .eq. 'END' .or. of_Name .eq. 'end' ) Then
C             Abort.
             Write( *, '('' WARNING:: No output file written'')' )
             Flag = -1
             Return
            Else If( of_Name( 1: 1 ) .eq. '$' ) Then       ! DCL command
             Call arkcom( of_Name( 2: 50 ))
           Else If( of_Name .eq. 'ark' .or. of_Name .eq. 'ARK' ) Then
             If( Flag .eq. 2 ) Then
              Write( *, '('' Changing to ARK format'')' )
             Else
              Write( *, '('' Returning to ARK format'')' )
             End If
             in_Flag = 1
           Else
              call arkopn(iUnit, of_Name, ' ', 'new', 'overwrite',
     &             'formatted', ' ', 0)
             If (IUE) Call WRITE_IUE_HEADER( iUnit, min, Pix )
             Do J = min, Pix
              Write( iUnit, * ) X( J ), Y( J )
             End Do
             Close( iUnit )
             Return
           End If
         End If
       End Do
C
       End
C
C
C
       Subroutine WRITE_IUE_HEADER( Unit, min, Pix )
C
C       ARK/IUE version only
C
        use get_header

        implicit none

       Integer Unit, min, Pix
C
       Character*8 Key
       Integer K, L, Length

C
       Character*80 Dross( 180 )
       Common / pasDrs / Dross
C
       L = 0
       Length = LNDRSS( )
       Do K = 1, Length
         Key = Dross( K )( 1: 8 )
         If( Key .ne. 'SIMPLE  ' .and. Key .ne. 'REALTYPE'
     1       .and. Key .ne. 'NAXIS   ' .and. Key .ne. 'NAXIS1  '
     2       .and. Key .ne. 'ARK-NODE' .and. Key .ne. 'END' ) Then
           L = L + 1
           Write( Unit, 100 ) Dross( K )( 1: 65 )
100           Format( ' ! ', A65 )
C           Shouldn't need ' ', if opend c-ctrl=list.
         End If
         If( L .eq. 3 ) Goto 200
       End Do
c       If you get to here L is zero or 1.  Add some blank lines.
        If ( L .lt. 3 ) Write( Unit, * ) '!'
        If ( L .lt. 2 ) Write( Unit, * ) '!'
        If ( L .lt. 1 ) Write( Unit, * ) '!'
200       Continue
C
       End
C
C
C                      
       Subroutine SAVE_AI_ARK( X, Y, min, Pix, C, Order, Unit )
C
        use get_header

        implicit none

       Integer min, Pix, Order, Unit
       Real X( Pix ), Y( Pix )
       Double Precision C( 0: 9 )
C
       Character*80 out_Header( 36 )
       Character*8 Key, a_Node
       Integer length, J, K, L, N, IO_test, anode_Length
       Real RMS
       Double Precision Alpha( 0: 9, 0: 9 )
       Double Precision Add, Mul, Temp
C
       Character*80 Dross( 180 )
       Common / pasDrs / Dross

        integer, external :: arkgsm
C
       length = Pix - min + 1
C              Construct output header; first, compulsory header
       out_Header( 1 ) = 
     &  'SIMPLE  =                    A /ARK FILE'
       out_Header( 2 ) = 
     &  'REALTYPE=                    V /VAX REAL NUMBER'
       out_Header( 3 ) = 
     &  'NAXIS   =                    1 /ONE DIMENSIONAL'
       out_Header( 4 ) = 
     &  'NAXIS1  =                      /NO OF DATA POINTS'
       Write( out_Header( 4 )( 21: 30 ), '(I10)' ) length
       L = 4
       IO_Test = arkgsm( 'ARK_NODE', a_Node, anode_Length )
       If( IO_Test .eq. 1 ) Then
C         DCL symbol ARK_NODE defined.
          do j=1, 8
            if (a_Node(j:j).ne.' ' .and. a_Node(j:j).ne.char(0))
     &      anode_Length=j
          end do
         out_Header( 5 ) = 
     &    'ARK-NODE= ''                    /FILE CREATED AT'
         out_Header( 5 )( 12: anode_Length + 11 ) = 
     &    a_Node( 1: anode_Length )
         out_Header( 5 )( anode_Length + 12: anode_Length + 12 ) = ''''
         L = 5
       End If
       N = LNDRSS( )
C       Now, copy DROSS into out_Header.
       Do K = 1, N
         Key = Dross( K )( 1: 8 )
         If( Key .ne. 'SIMPLE  ' .and. Key .ne. 'REALTYPE'
     1              .and. Key .ne. 'NAXIS   ' .and. Key .ne. 'NAXIS1  '
     2              .and. Key .ne. 'BITPIX  ' .and. Key .ne. 'ARK-NODE'
     3          .and. Key .ne. 'END     ') Then
           L = L + 1
           If( L .le. 36 ) Then
             If( Dross( K )( 9: 9 ) .eq. '=' ) Then
              out_Header( L ) = Dross( K )
              Else If( Dross( K ) .eq. 'END' ) Then
                out_Header( L ) = Dross( K )
             Else
              out_Header( L ) = 
     &          'COMMENT = ''' // Dross( K )( 1: 68 ) // ''''
             End If
           Else
             L = L - 1
           End If
         End If
       End Do
       If( L .le. 35 .and. out_Header( L ) .ne. 'END' ) Then
         L = L + 1
         out_Header( L ) = 'END'
       End If
       Do K = L + 1, 36
         out_Header( K ) = ' '
       End Do
C              Now calculate C if necessary
       If( Order .eq. 0 ) Then              ! C unknown
         RMS = ( X( Pix ) - X( min ) ) / length * 0.01
         iorder=9
         Call LTCHEB( X( min ), length, C, Order, RMS )
       Else
         If( min .ne. 1 ) Then              ! starting pixel shifted
           Add = 1 - min
           Mul = 1.0
           Call LCNVRT( Alpha, 9, Add, Mul )
           Do J = 0, Order
             Temp = 0.0
             Do K = J, Order
              Temp = Temp + Alpha( K, J ) * C( K )
             End Do
             C( J ) = Temp
           End Do
         End If
       End If
       Write( Unit ) length, out_Header
       Write( Unit ) ( Y( J ), J = min, Pix )
       Write( Unit ) C
       Close( Unit )
C
       End
C
C
C
       Subroutine ARKIO_ADDCOM( Flag )

        implicit none

C
       Integer Flag       ! Add comments if Flag = 1, not if flag=0
C
       Logical add_Comments
       Common / addCom / add_Comments
C
       If( Flag .eq. 1 ) Then
         add_Comments = .True.
       Else
         add_Comments = .False.
       End If
C
       End

       block data

       Logical add_Comments
       Common / addCom / add_Comments
       Data add_Comments / .True. /

       end
